/**
 * 
 */
package gov.va.med.mhv.liferay.saml.profile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;

import com.liferay.saml.profile.SingleLogoutProfileImpl;

import gov.va.med.mhv.liferay.saml.aal.AccountActivityClient;

/**
 * @author DNS
 *
 */
public class MhvSingleLogoutProfileImpl extends SingleLogoutProfileImpl {
	
	private static final String SESSION_USERPROFILE_ID = "LIFERAY_SHARED_userprofileid";
	private static final String SESSION_MHV_API_TOKEN = "LIFERAY_SHARED_api_token";
	private static final String AAL_ACTIVITY = "Logout";
	private static final String AAL_ACTION = "Logout for %s.";
	private static final String AAL_ACTOR = "Self";

	private AccountActivityClient aalClient = null;
	
	@Override
	protected void processSingleLogoutRequest(HttpServletRequest request, HttpServletResponse response,	SAMLMessageContext<LogoutRequest, LogoutResponse, NameID> samlMessageContext)
		throws Exception {

		String entityId = samlMessageContext.getPeerEntityId();
		Object userProfileId = (Long)request.getSession().getAttribute(SESSION_USERPROFILE_ID);
		Object apiToken = (String)request.getSession().getAttribute(SESSION_MHV_API_TOKEN);
		
		if(userProfileId != null && apiToken != null) {
			aalClient.createAccountActivity((Long)userProfileId, AAL_ACTOR, true, AAL_ACTIVITY, String.format(AAL_ACTION, entityId), entityId, (String)apiToken);
		}
		
		super.processSingleLogoutRequest(request, response, samlMessageContext);
	}
	
	public void setAalClient(AccountActivityClient aalClient) {
		this.aalClient = aalClient;
	}

}
